# Production

1. Introduction
2. [Orientation](production#orientation)
3. [Understanding Publication Formats](production#understanding-publication-formats)
3. [Publishing the Submission](production#publish)

During the Production stage, the editor assigns production assistants who will help prepare the final publication files.

Common publication formats include PDF and ePub, but you may also prepare a number of other formats, such as HTML files or an eLens reader, depending on what formats your administrator has enabled.

## <a name="orientation"></a>Orientation

The Production stage provides three panels to create files ready for publication.

### <a name="production-ready"></a>Production Ready Files

All files selected by the editor for production will appear here. These typically include files that have been prepared during the [Copyediting stage](copyediting). Production assistants will use these files to generate the final publication formats.

### <a name="production-discussions"></a>Production Discussions

Editors and production assistants can use this panel to initiate conversations, if there are any details that need to be clarified before the final publication formats can be created.

### <a name="publication-formats"></a>Publication Formats

Editors and production assistants can create publication formats and upload files to each format. Learn more about [publication formats](production#understanding-publication-formats).

Once publication formats have been created and files have been uploaded, you can begin the approval process to [publish the submission](production#publish).

### <a name="participants"></a>Participants

Editors can add copyeditors from this panel. [Learn more](../editorial-workflow#participants).

## <a name="understanding-publication-formats"></a>Understanding Publication Formats

Each format represents one type of file (PDF, ePub), and may have multiple files attached to it, such as separate chapter files or supplementary data.

### Organizing Your Publication Formats

How you choose to organise your publication formats is up to you. But that flexibility may be confusing as you're just getting used to the publishing platform. Here are a couple of simple examples.

A typical monograph might have one publication format named ePub with a single `.epub` file uploaded to it. It might have another publication format named PDF with separate `.pdf` files uploaded to it for each chapter and supplementary data.

In this case, you'd create two Publication Formats, ePub and PDF, and upload the files separately under each Publication Format.

If you publish physical volumes alongside your digital offering, you can create entries for these as well. You can upload files to these publication formats if you'd like and they will be displayed for download. This is not common, but might be used for a printable order form if you do not have an online sales platform.

### <a name="publication-format-metadata"></a>Managing Your Publication Format Metadata

Each publication format has it's own set of metadata, including DOIs, to comply with indexing services like Google Scholar. You're encouraged to complete the metadata relevant to your needs.

Once you've created a publication format, you'll find a new tab in the [Catalog Entry](../editorial-workflow#catalog-entry) panel. To access this panel, look above the stages in the editorial workflow and find the submission title and author.

Click the **Catalog Entry** link in this area and you'll find a tab for each of your publication formats.

## <a name="publish"></a>Publishing the Submission

OMP offers a flexible publishing workflow which allows you to publish just the parts you want, when you want. That means there are separate levels of control for the catalog entry, each publication format, and even each file within a publication format.

To help guide you through the last steps of the publishing process, each of these levels is described below.

### Catalog Entry

An entry can be created for this submission in the catalog at any time during the editorial workflow. This is often used to list forthcoming publications before they've made it through the final publication process.

To add an entry, go to the **Catalog Entry > Catalog** panel and check the box labeled *Add this book to the public catalog*. You'll find the **Catalog Entry** link at the top, near the submission title and author.

*Nothing will appear in your catalog until you've created a catalog entry, even if you've approved publication formats.*

### Publication Formats

Each publication format will have a two-step approval process.

The first checkbox, which says "Awaiting Approval", is for editors to sign off when the [publication format's metadata](production#publication-format-metadata) is ready for publication.

The second checkbox, which says "Not Available", is for approving the publication format for display to readers. Once this checkbox is toggled, any approved files will be shown to the user.

*If a publication format has no approved files, it will not appear in the catalog.*

### Publication Format Files

Files are uploaded to each publication format and need to be approved separately.

The first checkbox, which says "Awaiting Approval", is for editors to sign off on the file's readiness for publication.

The second checkbox, which says "Set Terms", controls the terms under which the file is displayed to readers. You'll need to set this to something other than "No Access" before the file will be shown in the catalog entry.
